<?php
class EsxiManager {
    static function enableSshService( $id ) {
        $esxiInfoArray = ConfManager::getEsxiInfo( $id ) ;
        
        CommonUtility::signalIgnore() ;
        CommonUtility::stepRunProgramAtMs( array(
            "stepname"  => "EnableEsxiSshService",
            "program"   => "/usr/bin/perl",
            "arguments" => array(
                "/opt/TrendMicro/Pixiebob/textUI/hostServiceManagement.pl",
                "--server",     $esxiInfoArray[ "ip" ],
                "--portnumber", $esxiInfoArray[ "port" ],
                "--username",   $esxiInfoArray[ "username" ],
                "--password",   $esxiInfoArray[ "password" ],
                "--service",    "TSM-SSH",
                "--operation",  "start"
        ) ) ) ;
        CommonUtility::signalDefault() ;
    }
    
    static function disableSshService( $id ) {
        $esxiInfoArray = ConfManager::getEsxiInfo( $id ) ;
        
        CommonUtility::signalIgnore() ;
        CommonUtility::stepRunProgramAtMs( array(
            "stepname"  => "DisableEsxiSshService",
            "program"   => "/usr/bin/perl",
            "arguments" => array(
                "/opt/TrendMicro/Pixiebob/textUI/hostServiceManagement.pl",
                "--server",     $esxiInfoArray[ "ip" ],
                "--portnumber", $esxiInfoArray[ "port" ],
                "--username",   $esxiInfoArray[ "username" ],
                "--password",   $esxiInfoArray[ "password" ],
                "--service",    "TSM-SSH",
                "--operation",  "stop"
        ) ) ) ;
        CommonUtility::signalDefault() ;
    }
    
    static function getHostname( $id ) {
        $esxiInfoArray = ConfManager::getEsxiInfo( $id ) ;
        
        $ret_array = CommonUtility::stepRunProgramAtMs( array(
            "stepname"  => "GetEsxiHostnameInfo",
            "program"   => "/usr/bin/esxcli",
            "arguments" => array(
                "--server",    $esxiInfoArray[ "ip" ],
                "--port",      $esxiInfoArray[ "port" ],
                "--username",  $esxiInfoArray[ "username" ],
                "--password",  $esxiInfoArray[ "password" ],
                "system",
                "hostname",
                "get"
        ) ) ) ;

        $hostname = null ;
        foreach( $ret_array[ 1 ] as $line ) {
            $ptn     = '/^\s* Host \s Name: \s (.*)/ix' ;
            $mResult = preg_match( $ptn, trim( $line ), $matches ) ;
            if( $mResult !== false && $mResult !== 0 ) {
                $hostname = isset( $matches[ 1 ] ) ? $matches[ 1 ] : null ;
            }
        }
        
        CommonUtility::debug_print( "EsxiHostname='$hostname'" ) ;
        return $hostname ;
    }
    
    static function setHostname( $id, $hostname = "localhost" ) {
        $esxiInfoArray = ConfManager::getEsxiInfo( $id ) ;
        
        CommonUtility::stepRunProgramAtMs( array(
            "stepname"  => "SetEsxiHostname",
            "program"   => "/usr/bin/esxcli",
            "arguments" => array(
                "--server",    $esxiInfoArray[ "ip" ],
                "--port",      $esxiInfoArray[ "port" ],
                "--username",  $esxiInfoArray[ "username" ],
                "--password",  $esxiInfoArray[ "password" ],
                "system",
                "hostname",
                "set",
                "--host", $hostname
        ) ) ) ;
    }
    
    static function getDomain( $id ) {
        $esxiInfoArray = ConfManager::getEsxiInfo( $id ) ;
        
        $ret_array = CommonUtility::stepRunProgramAtMs( array(
            "stepname"  => "GetEsxiHostnameInfo",
            "program"   => "/usr/bin/esxcli",
            "arguments" => array(
                "--server",    $esxiInfoArray[ "ip" ],
                "--port",      $esxiInfoArray[ "port" ],
                "--username",  $esxiInfoArray[ "username" ],
                "--password",  $esxiInfoArray[ "password" ],
                "system",
                "hostname",
                "get"
        ) ) ) ;
        
        $domain = null ;
        foreach( $ret_array[ 1 ] as $line ) {
            $ptn     = '/^\s* Domain \s Name: \s (.*)/ix' ;
            $mResult = preg_match( $ptn, trim( $line ), $matches ) ;
            if( $mResult !== false && $mResult !== 0 ) {
                $domain = isset( $matches[ 1 ] ) ? $matches[ 1 ] : null ;
            }
        }
        
        CommonUtility::debug_print( "EsxiDomain='$domain'" ) ;
        return $domain ;
    }
    
    static function setDomain( $id, $domain = "example.com" ) {
        $esxiInfoArray = ConfManager::getEsxiInfo( $id ) ;
        
        CommonUtility::stepRunProgramAtMs( array(
            "stepname"  => "SetEsxiHostname",
            "program"   => "/usr/bin/esxcli",
            "arguments" => array(
                "--server",    $esxiInfoArray[ "ip" ],
                "--port",      $esxiInfoArray[ "port" ],
                "--username",  $esxiInfoArray[ "username" ],
                "--password",  $esxiInfoArray[ "password" ],
                "system",
                "hostname",
                "set",
                "--domain", $domain
        ) ) ) ;
    }
    
    static function getIp( $id ) {
        $esxiInfoArray = ConfManager::getEsxiInfo( $id ) ;
        
        $ret_array = CommonUtility::stepRunProgramAtMs( array(
            "stepname"  => "GetEsxiHostnameInfo",
            "program"   => "/usr/bin/esxcli",
            "arguments" => array(
                "--server",    $esxiInfoArray[ "ip" ],
                "--port",      $esxiInfoArray[ "port" ],
                "--username",  $esxiInfoArray[ "username" ],
                "--password",  $esxiInfoArray[ "password" ],
                "network",
                "ip",
                "interface",
                "ipv4",
                "get"
        ) ) ) ;

        $ipArray = array() ;
        foreach( $ret_array[ 1 ] as $line_no => $line ) {
            if( $line_no <= 1 ) {
                continue ;
            }
            $ptn     = '/\s+/' ;
            $mResult = preg_split( $ptn, trim( $line ) ) ;
            if( $mResult !== false && $mResult !== 0 ) {
                $interface = isset( $mResult[ 0 ] ) ? $mResult[ 0 ] : "" ;
                $ip        = isset( $mResult[ 1 ] ) ? $mResult[ 1 ] : "" ;
                $ipArray[ $interface ] = $ip ;
            }
        }
        
        return $ipArray ;
    }
    
    static function setDefaultGateway( $id, $default_gateway ) {
        $esxiInfoArray = ConfManager::getEsxiInfo( $id ) ;
        
        CommonUtility::stepRunProgramAtMs( array(
            "stepname"  => "SetEsxiDefaultGateway",
            "program"   => "/usr/bin/vicfg-route",
            "arguments" => array(
                "--server",     $esxiInfoArray[ "ip" ],
                "--portnumber", $esxiInfoArray[ "port" ],
                "--username",   $esxiInfoArray[ "username" ],
                "--password",   $esxiInfoArray[ "password" ],
               $default_gateway
        ) ) ) ;
    }
    
    static function runProgramBySsh( $id, $argv ) {
        $esxiInfoArray = ConfManager::getEsxiInfo( $id ) ;

        $program    = $argv[ 'program' ] ;
        $arguments  = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
        $isBlocking = isset( $argv[ 'is_block' ] )  ? $argv[ 'is_block' ]  : true ;
        $stepname   = isset( $argv[ 'stepname' ] )  ? $argv[ 'stepname' ]  : "runProgramBySsh" ;
        
        # escape arguments
        for( $i = 0 ; $i < count( $arguments ); $i++ ) {
            $arguments[ $i ] = escapeshellarg( $arguments[ $i ] ) ;
        }

        # compose command
        $command = join( " ", array( $program,
                                     join( " ", $arguments ),
                                     "; echo \$?" ) ) ;
        CommonUtility::debug_print( "command='$command'" ) ;

        # get ssh connection
        $connection = CommonUtility::getSshConnection(
                            $esxiInfoArray[ "ip" ],
                            $esxiInfoArray[ "username" ],
                            $esxiInfoArray[ "password" ] ) ;
        # execute
        $stdoutStream = ssh2_exec( $connection, $command ) ;
        $stderrStream = ssh2_fetch_stream( $stdoutStream, SSH2_STREAM_STDERR ) ;

        if( $stdoutStream === false ) {
            $msg = "ExecuteCommandFail: command='$command'" ;
            CommonUtility::debug_print( $msg ) ;
            return array( "1", array( $msg ) ) ;
        }

        # wait for execution result
        $retValue = "0" ;
        $outMsgArray = array() ;
        $errMsgArray = array() ;
        if( $isBlocking === true ) {
            CommonUtility::debug_print( "WaitingForSshResult..." ) ;
            stream_set_blocking( $stdoutStream, 1 ) ;
            
            $outMsgArray = preg_split( "/\n+/", trim( stream_get_contents( $stdoutStream ) ) ) ;
            $errMsgArray = preg_split( "/\n+/", trim( stream_get_contents( $stderrStream ) ) ) ;
            CommonUtility::debug_print( "ReceivedSshResult..." ) ;
            
            $retValue = array_pop( $outMsgArray ) ;
        }
        fclose( $stdoutStream ) ;
        fclose( $stderrStream ) ;

        return array( $retValue,
                      $outMsgArray,
                      $errMsgArray ) ;
    }

    static function stepRunProgramBySsh( $id, $argv ) {
        $stepName = isset( $argv[ "stepname" ] ) ? $argv[ "stepname" ] : "RunProgramAtEsxi" ;
        
        # composing debug message
        $msg = $stepName . ": " . escapeshellarg( $argv[ 'program' ] ) ;
        $argumentsArray = isset( $argv[ 'arguments' ] ) ? $argv[ 'arguments' ] : array() ;
        foreach( $argumentsArray as $argument ) {
            $msg .=  " " . escapeshellarg( $argument ) ;
        }
        CommonUtility::debug_print( $msg ) ;
        
        # launching
        $ret_array = self::runProgramBySsh( $id, $argv ) ;
        
        # verify return code
        $retCode      = $ret_array[ 0 ] ;
        $stdoutMsgAry = $ret_array[ 1 ] ;
        $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
        if( $retCode != 0 ) {
            $stderrMsgAry = $ret_array[ 2 ] ;
            $stderrMsg    = join( "\n", $stderrMsgAry ) ;
            throw new Exception( "${stepName}Fail: ret='$retCode', msg='$stderrMsg'" ) ;
        }
        CommonUtility::debug_print( "${stepName}Pass: msg='$stdoutMsg'" ) ;
        
        return $ret_array ;
    }
}

if( realpath( $_SERVER[ "SCRIPT_NAME" ] ) == realpath( __FILE__ ) ) {
    require_once( "Constants.class.php" ) ;
    require_once( "CommonUtility.class.php" ) ;
    require_once( "ConfManager.class.php" ) ;
    require_once( "DbManager.class.php" ) ;
    require_once( "ScManager.class.php" ) ;

    try {
        // EsxiManager::enableSshService( "1" ) ;
        // EsxiManager::disableSshService( "1" ) ;
        // EsxiManager::disableSshService( "1" ) ;
        
        print_r( EsxiManager::getIp( "1" ) ) ;
    }
    
    catch( Exception $e ) {
        echo "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() . "\n" ;
    }
}
